/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser.DisplayPort;

import com.quantumdata.busmon.parser.DisplayPort.DisplayPortAddressMapping;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortMessage;

public class DisplayPortRequestMessage
extends DisplayPortMessage {
    private int aAddress;
    private int aDataLength;
    private boolean aIsMotSet;

    public DisplayPortRequestMessage(int n, int n2, int n3, byte[] byArray, boolean bl) {
        super(n, byArray);
        this.aAddress = n2;
        this.aDataLength = n3;
        this.aIsMotSet = bl;
    }

    public int getAddress() {
        if (this.isNative()) {
            return this.aAddress;
        }
        return this.aAddress << 1;
    }

    public String getDetails() {
        StringBuffer stringBuffer;
        block6: {
            int n;
            byte[] byArray;
            block7: {
                block5: {
                    stringBuffer = new StringBuffer("");
                    if (!this.isNative()) {
                        return stringBuffer.toString();
                    }
                    if (this.getMessageType() == 1) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append("Display Port Message Details\n");
                    stringBuffer.append("----------------------------\n");
                    byArray = this.getData();
                    n = this.getAddress();
                    if (!DisplayPortDataBlock.addressBlockIsReserved(n)) break block5;
                    stringBuffer.append("DisplayPort Address " + DisplayPortDataBlock.longAddressToHexString(n) + " is RESERVED\n");
                    break block6;
                }
                if (!DisplayPortDataBlock.addressIsHDCPBlock(n)) break block7;
                if (byArray == null) break block6;
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(DisplayPortDataBlock.getHDCPData(n, byArray[i]));
                    ++n;
                }
                break block6;
            }
            if (byArray != null) {
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(DisplayPortDataBlock.getContentData(n, byArray[i]));
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer("");
        switch (this.getMessageType()) {
            case 1: {
                int n = this.getDataLength();
                stringBuffer.append("NATIVE READ OF " + n + " BYTES FROM ");
                if (DisplayPortAddressMapping.IsMultiByteHDCPAddressRegister(this.getAddress()) && n == 1) {
                    stringBuffer.append(DisplayPortAddressMapping.GetAddressName(this.getAddress()) + "[" + DisplayPortAddressMapping.GetMultiByteHDCPAddressRegisterIndex(this.getAddress()) + "] [" + String.format("0x%1$05X", this.getAddress()) + "]");
                    break;
                }
                stringBuffer.append(DisplayPortAddressMapping.GetAddressName(this.getAddress()) + " [" + String.format("0x%1$05X", this.getAddress()) + "]");
                break;
            }
            case 2: {
                int n = this.getDataLength();
                stringBuffer.append(String.format("NATIVE WRITE OF %1$d BYTES TO ", n));
                if (DisplayPortAddressMapping.IsMultiByteHDCPAddressRegister(this.getAddress()) && n == 1) {
                    stringBuffer.append(DisplayPortAddressMapping.GetAddressName(this.getAddress()) + "[" + DisplayPortAddressMapping.GetMultiByteHDCPAddressRegisterIndex(this.getAddress()) + "] [" + String.format("0x%1$05X:  ", this.getAddress()));
                } else {
                    stringBuffer.append(DisplayPortAddressMapping.GetAddressName(this.getAddress()) + " [" + String.format("0x%1$05X:  ", this.getAddress()));
                }
                byte[] byArray = this.getData();
                for (int i = 0; i < this.getDataLength(); ++i) {
                    stringBuffer.append(String.format("0x%1$02X ", byArray[i]));
                }
                stringBuffer.append("]");
                break;
            }
            case 3: {
                if (this.getDataLength() == 0) {
                    stringBuffer.append("ADDRESS ONLY I2C WRITE OF ADDRESS ");
                    stringBuffer.append(String.format("0x%1$02X  ", this.getAddress()));
                    stringBuffer.append(this.isMotSet() ? "(MOT = 1)" : "(MOT = 0)");
                    break;
                }
                stringBuffer.append("I2C WRITE OF ADDRESS ");
                byte[] byArray = this.getData();
                for (int i = 0; i < this.getDataLength(); ++i) {
                    stringBuffer.append(String.format("0x%1$02X ", byArray[i]));
                }
                stringBuffer.append(String.format("TO 0x%1$02X  ", this.getAddress()));
                stringBuffer.append(this.isMotSet() ? "(MOT = 1)" : "(MOT = 0)");
                break;
            }
            case 4: {
                if (this.getDataLength() == 0) {
                    stringBuffer.append("ADDRESS ONLY I2C READ OF ADDRESS ");
                    stringBuffer.append(String.format("0x%1$02X  ", this.getAddress()));
                    stringBuffer.append(this.isMotSet() ? "(MOT = 1)" : "(MOT = 0)");
                    break;
                }
                stringBuffer.append("I2C READ " + this.getDataLength() + " BYTES FROM ");
                stringBuffer.append(String.format("0x%1$02X  ", this.getAddress()));
                stringBuffer.append(this.isMotSet() ? "(MOT = 1)" : "(MOT = 0)");
                break;
            }
            case 5: {
                if (this.getDataLength() != 0) break;
                stringBuffer.append("I2C WRITE STATUS REQUEST FOR ADDRESS ");
                stringBuffer.append(String.format("0x%1$02X  ", this.getAddress()));
                stringBuffer.append(this.isMotSet() ? "(MOT = 1)" : "(MOT = 0)");
            }
        }
        return stringBuffer.toString();
    }

    public String getMessageTypeText() {
        return null;
    }

    public int getDataLength() {
        return this.aDataLength;
    }

    public boolean isMotSet() {
        return this.aIsMotSet;
    }

    public String getDirection() {
        return "REQUEST";
    }

    public boolean isEvent() {
        return false;
    }

    public boolean isI2C() {
        return !this.isNative();
    }

    public boolean isHDCP() {
        return this.isNative() && DisplayPortDataBlock.addressIsHDCPBlock(this.getAddress());
    }

    public boolean isDDCCI() {
        return this.getAddress() == 110 && this.isI2C();
    }

    public boolean isEDID() {
        return this.isI2C() && (this.getAddress() == 160 || this.getAddress() == 96);
    }

    public boolean isLT() {
        return this.isNative() && DisplayPortDataBlock.addressIsLT(this.getAddress());
    }
}

